---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-CGI プロバイダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.CGI.pas` - CGI プロバイダー実装（Delphi版、51行）
- E-02: `src/Horse.Provider.FPC.CGI.pas` - CGI プロバイダー実装（FPC版、92行）
- E-03: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（77行）
- E-04: `src/Horse.WebModule.pas` - WebModule実装（118行）
- E-05: `src/Horse.pas` - メインユニット（117行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HORSE_CGI コンパイルディレクティブで有効化（Delphi） | E-01: 5行目 `{$IF DEFINED(HORSE_CGI) AND NOT DEFINED(FPC)}` | ○ |
| C-02 | HORSE_CGI コンパイルディレクティブで有効化（FPC） | E-02: 9行目 `{$IF DEFINED(HORSE_CGI) AND DEFINED(FPC)}` | ○ |
| C-03 | Web.CGIApp を使用（Delphi版） | E-01: 25行目 `Web.CGIApp` | ○ |
| C-04 | fpCGI を使用（FPC版） | E-02: 13行目 `fpCGI` | ○ |
| C-05 | Application.Initialize 呼び出し | E-01: 30行目, E-02: 69行目 | ○ |
| C-06 | WebModuleClass設定 | E-01: 31行目, E-02: 67行目（OnGetModule経由） | ○ |
| C-07 | DoOnListen でコールバック実行 | E-01: 32行目, E-02: 70行目 | ○ |
| C-08 | Application.Run 呼び出し | E-01: 33行目, E-02: 71行目 | ○ |
| C-09 | StopListen 機能なし | E-01, E-02: StopListen メソッドの実装なし | ○ |
| C-10 | THorseProviderAbstract を継承 | E-01: 11行目, E-02: 20行目 | ○ |
| C-11 | FPC版で AllowDefaultModule = True | E-02: 66行目 | ○ |
| C-12 | FPC版で LegacyRouting = True | E-02: 68行目 | ○ |
| C-13 | FPC版で DoGetModule イベント設定 | E-02: 67行目, 74-77行目 | ○ |
| C-14 | Webモジュールとの関連 | E-06: 画面No.7, 8とのマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Delphi版とFPC版の実装差異が正しく記述されているか
- [ ] CGIモデルの特性（StopListen不可）が正しく理解されているか
- [ ] FPC版のOnGetModuleイベント処理が正しく説明されているか
